#include <iostream>
#include <chrono>
#include <thread>
/**
 * ====================================================================
 * @file epoch-rt.cpp
 * @brief Affichage temps réel Epoch
 * @version 1.0 
 * @author alg
 * @date 15-08-25
 * @license GPLv3
 * =====================================================================
 * NOTA:
 * Petit programme pour calculer les nombres palindromes à partir de
 * Epoch UNIX. On converti dans une format lisible par le code machine
 * en base16 (puissance de 2, base carré). On affiche en temps réel 
 * toutes les secondes pour synchroniser le temps.
 */


int main() {
    using namespace std::chrono;

    while (true) {
        // Récupère l'heure actuelle en secondes depuis l'epoch
        auto now = system_clock::now();
        auto epoch = duration_cast<seconds>(now.time_since_epoch()).count();

        // Efface l'écran (optionnel, pour affichage "propre")
        std::cout << "\033[2J\033[H";

        // Affiche en décimal
        std::cout << "Epoch (dec) : " << epoch << "\n";

        // Affiche en hexadécimal
        std::cout << "Epoch (hex) : 0x" 
                  << std::hex << std::uppercase << epoch << std::dec << "\n";

        // Attente d'une seconde
        std::this_thread::sleep_for(seconds(1));
    }
}

