/**
 * ====================================================================
 * @file euromillions.cpp
 * @brief Generer grille
 * @version 1.1 
 * @author alg
 * @date 13-08-25
 * @license GPLv3
 * =====================================================================
 * NOTA:
 * Pour générer les grilles lancer le programme à des moments symboliques
 * ex générer à 11:11 (palindrome) AM le 21/12/25 (soltice) à la 
 * nouvelle lune, etc...
 * Permet de synchroniser le temps localement et le cosmos dans le flux
 * energétique cosmique et de lancer une priorité de traitement dans la
 * machine cosmic comme requête. La pattern narkantik permet de lancer
 * des priorités comme commande.
 */
#include <algorithm>
#include <array>
#include <chrono>
#include <iostream>
#include <numeric>
#include <random>
#include <vector>
#include <ctime>

struct Grille {
    std::array<int, 5> numeros;
    std::array<int, 2> etoiles;
};

Grille generer_grille() {
    // Générateur aléatoire robuste, entropie materielle
    std::random_device rd;

    // seed_seq = mélange de plusieurs valeurs pour produire une graine plus robuste
    // rd () = deux appels à random device
    // Le temps actuel en nanoseconde
    std::seed_seq seed{rd(), rd(), static_cast<unsigned>(std::chrono::high_resolution_clock::now().time_since_epoch().count())};
    
    // Generateur Mersenne Twistter
    std::mt19937 rng(seed);

    // Pool 1..50 pour les numéros
    std::vector<int> pool_num(50);
    std::iota(pool_num.begin(), pool_num.end(), 1); // remplit avec 1, 2..., 50 
    std::shuffle(pool_num.begin(), pool_num.end(), rng); // melange aleatoire

    // Pool 1..12 pour les étoiles
    std::vector<int> pool_star(12);
    std::iota(pool_star.begin(), pool_star.end(), 1); // remplit avec 1, 2, ... 12 
    std::shuffle(pool_star.begin(), pool_star.end(), rng); // mélange aleatoire 

    Grille g{};
    // On prend les 5 premiers numéros et les 2 premières étoiles (aucun doublon possible)
    std::copy_n(pool_num.begin(), 5, g.numeros.begin());
    std::copy_n(pool_star.begin(), 2, g.etoiles.begin());

    // Tri pour affichage propre (optionnel)
    std::sort(g.numeros.begin(), g.numeros.end());
    std::sort(g.etoiles.begin(), g.etoiles.end());

    return g;
}

int main() {
    auto g = generer_grille();

    std::cout << R"(
# ---------------------TICKET NARKANTIK---------------------------
# MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM
    )" << std::endl;
    std::cout << "          Génération de votre Grille Euromillions FDJ:" << std::endl;
    std::cout << "------------------------------------------------------------------" << std::endl;
    std::cout << "Numeros 🀄 : ";
    for (std::size_t i = 0; i < g.numeros.size(); ++i) {
        std::cout << g.numeros[i] << (i + 1 < g.numeros.size() ? " " : "");
    }

    std::cout << " | Etoiles ✯ : ";
    for (std::size_t i = 0; i < g.etoiles.size(); ++i) {
        std::cout << g.etoiles[i] << (i + 1 < g.etoiles.size() ? " " : "");
    }
    std::cout << '\n';
    std::cout << "------------------------------------------------------------------" << std::endl;
    std::time_t now = std::time(nullptr); // seconde UNIX
    std::cout << "Date (EPOCH UNIX) : " << now << "\n";
    std::cout << "Cryptogramme base16 Narkantique : 0x" << std::hex << std::uppercase << now << "\n";
    std::cout << R"(

# [LOADING ⏳ ] Priorité traitement file d'attente machine cosmic
# ------------------ FINGERPRINTING SEAL -------------------------
# MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMWWKXWMMMMMMMMMMMMMMMMMMMMMMMM
# MMMMWMMMMMMMMMMMMMMMMMMMMMMMMMMWKOdcl:;xNMMMMMMMMMMMMMMMMMMMMMMM
# MMMWWMMMMMMMMMMMMMMMWMMMMMMWKkdc,.......:kNMMWMMMWMMWWMMMMMMMMMM
# MMMWWMMMMMMMMMMMMMMMMMMMMWKd;....,..   ...c0WWWMMMMMWWMMMMMMMMMM
# MMMMWMMMMMMMMMMMMMMMMMWNkl'.....''.   . ....c0WMMMMMMMMMMMMMMMMM
# MMMMWMMMMMMMMMMMMMMMWXx:'......... ..  .    .,lKWMMMMMMMMMMMMMMM
# MMMWWMMMMMMMMMMMMMXxc,....... ..... ....    .'',xNMMMWMMMMMMMWMM
# MMMWWMMMMMMMMWWWXx;..        ..  . ..  ..  . .,;,cOWMMMMMMMMMMMM
# MMMMWMMMMMMMWWXd,..                ....   ...  .,.'oXMMMMMMMMMMM
# MMMWWMMMMMMWNk;...... ........ ..     ..  .... .....;OWMMMMMMMMM
# MMMWWMMMWWMXo'..  ..  ..'.....;cooddl,...   ..   ....;xNMMMMMMMM
# MMMWWMMMWWNd'..       ...,lxkKWMMMMMMN0xc.. ...  .....cOWMMMMWMM
# MMMWWMMMMNd'...       .'lOXWMMMMMMMMMMMMXo.. .'..   ..'lOWMMMMMM
# MMMWWMMMXo'.  ...    .c0WMMMMMMMMMMMMMMMMNo,'. ..   ...'lKMMMMMM
# MMMWWMWWx.....     .'xNMMMMMMMMMMMMMMMMMMMNd,.   .. ....,kMMMMMM
# MMMWWMMWo........ .c0WMMMMMMMMMMMMMMMMMMMMMXc... ......,,dWMMMMM
# MMMWWMMK;. ... ...dNMMMMMMMMMMMMMMMMMMMMMMMM0c:'.. .'..'.oWMMMMM
# MMMMMMMk.  ..  ..lNMMMMMMMMMMMMMMMMMMMMMMMMMWxc:.. ....''kMMMMMM
# MMMWWMMd. ...   .kMMMMMMMMMMMMMMMMMMMMMMMMMMMx........,';0MMMMMM
# MMMWWMWo.  ...  ,0MMMMMMMMMMMMMMMMMMMMMMMMMMMk'......',cOWMMMMMM
# MMMWWMWKc.  ..  ;XMMMMMMMMMMMMMMMMMMMMMMMMMMM0;.......'xWMMMMMMM
# MMMWWMMMK;      '0MMMMMMMMMMMMMMMMMMMMMMMMMMM0,..... .oNMMMMMMMM
# MMMWWMMMWx'.    .xWMWWMMMMMMMMMMMMMMMMMMMMMMMk. ... .lNMMMMMMMMM
# MMMWWMMMMNx'     cNMWWMMMMMMMMMMMMMMMMMMMMMMMk.    .oXMMMMMMMMMM
# MMMWWMMMMMW0;    ,KMMMMMMMMMMMMMMMMMMMMMMMMMWo.   'xNMMMMMMMMMMM
# MMMWMMMMMMMWXl.   oNWWMMMMMMMMMMMMMMMMMMMMMMK;  .,kWMMMMMMMMMMMM
# MMMMMMMMMMMMMNd.  .kWWMMMMMMMWMMMMMMMMMMMMMNo. .:KMMMMMWMMMMMMMM
# MMWWWMMMMMMWWMWO:. :XWMMMMMMWWMMMMMMMMWWMMM0'  'OWMMMMWWMMMMMMMM
# MMMWMMMMMMMWWMMMWO::0WMMMMMMMMMMMMMMMMWMMW0; .,OWMMMMMMMMMMMMMMM
# MMMMMMMMMMMWWMMMMMWNWMMMMMMMMWMMMMMMMMWWWO, .oXWMMMMMMMMMMMMMMMM
# MMMMMMMMMMMMMMMMMMMMWMMMMWKOKNMMMMMMMMWWk'.;OWWWWMMMMMMWWMMMMMMW
# NWWWMMMWWMMWNWWWWWWWWNWWNd. .oNWWWWWWWXd..oXWWWWWWWWWWWWWWWWMMMW
# XWWWMMMMMMMWWWWWWMMMWWMMWx..'xWWWWMMMNo.cKWMMMWWMMMMMMMMMMMMMMMM
# XWWWMMMMMMMMMMMMMMMMWMMMMWXKXWWMMMMMXl;xNMMMMMMWMMMMMMMWMMMMMMMM
# 0WWWMMMMMMMWWMMMMMMMWWMMMMMMWWWMMMMW0kKWMMMMMMMWMMMMMMMMMMMMMMMM
------------------------ALBA TAKIM WID----------------------------
    )" << std::endl;

    return 0;
}

